-- new script file
function OnAfterSceneLoaded(self)
	CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.activated = false 
    end  
    
    self.switchCount:LinkToTarget("unitInit")
    self.killCount:LinkToTarget("unitKill")
  end
  
  if self.activated then
    self.switchCount:TriggerAllTargets()
		self.activated = false
  end
end

function OnBeforeDeath(self)
  self.killCount:TriggerAllTargets()
end

function OnTrigger(self, source, target)
  if target == "reinfUnitSt" then
	  self.activated = true
  end
end

function OnSerialize(self, ar)
    if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.activated = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.activated)
  end  
end

function CreateTriggerTargets(self)
	self:AddTriggerTarget("reinfUnitSt")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("switchCount")
  self:AddTriggerSource("killCount")
end
